<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('sites', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->string('code')->nullable();
            $table->string('type')->nullable();
            $table->string('address')->nullable();
            $table->decimal('latitude', 10, 6)->nullable();
            $table->decimal('longitude', 10, 6)->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        Schema::table('assets', function (Blueprint $table) {
            $table->string('asset_tag')->nullable()->after('tenant_id');
            $table->string('make')->nullable()->after('name');
            $table->string('model')->nullable()->after('make');
            $table->string('serial_number')->nullable()->after('model');
            $table->string('year')->nullable()->after('serial_number');
            $table->string('category')->nullable()->after('year');
            $table->string('asset_type')->nullable()->after('category');
            $table->string('lifecycle_status')->default('active')->after('asset_type');
            $table->date('commissioned_at')->nullable()->after('lifecycle_status');
            $table->string('meter_type')->nullable()->after('commissioned_at');
            $table->decimal('meter_reading', 12, 2)->nullable()->after('meter_type');
            $table->foreignId('site_id')->nullable()->after('tenant_id')->constrained()->nullOnDelete();
            $table->unique(['tenant_id', 'asset_tag']);
        });

        Schema::table('vehicles', function (Blueprint $table) {
            $table->foreignId('asset_id')->nullable()->after('tenant_id')->constrained()->nullOnDelete();
            $table->foreignId('site_id')->nullable()->after('asset_id')->constrained()->nullOnDelete();
            $table->decimal('odometer', 12, 2)->nullable()->after('maintenance_schedule');
            $table->decimal('engine_hours', 12, 2)->nullable()->after('odometer');
        });

        Schema::table('maintenances', function (Blueprint $table) {
            $table->foreignId('tenant_id')->nullable()->after('id')->constrained()->nullOnDelete();
            $table->decimal('meter_reading', 12, 2)->nullable()->after('usage_hours');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('site_id')->nullable()->after('tenant_id')->constrained()->nullOnDelete();
            $table->string('phone')->nullable()->after('email');
            $table->string('whatsapp_number')->nullable()->after('phone');
            $table->string('telegram_handle')->nullable()->after('whatsapp_number');
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['site_id']);
            $table->dropColumn(['site_id', 'phone', 'whatsapp_number', 'telegram_handle']);
        });

        Schema::table('maintenances', function (Blueprint $table) {
            $table->dropForeign(['tenant_id']);
            $table->dropColumn(['tenant_id', 'meter_reading']);
        });

        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropForeign(['asset_id']);
            $table->dropForeign(['site_id']);
            $table->dropColumn(['asset_id', 'site_id', 'odometer', 'engine_hours']);
        });

        Schema::table('assets', function (Blueprint $table) {
            $table->dropUnique(['tenant_id', 'asset_tag']);
            $table->dropForeign(['site_id']);
            $table->dropColumn([
                'asset_tag',
                'make',
                'model',
                'serial_number',
                'year',
                'category',
                'asset_type',
                'lifecycle_status',
                'commissioned_at',
                'meter_type',
                'meter_reading',
                'site_id',
            ]);
        });

        Schema::dropIfExists('sites');
    }
};
