<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('checklists', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->string('type')->nullable();
            $table->json('items')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        Schema::create('downtime_reason_codes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('code')->nullable();
            $table->string('label');
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        Schema::create('work_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->constrained()->cascadeOnDelete();
            $table->foreignId('checklist_id')->nullable()->constrained()->nullOnDelete();
            $table->unsignedBigInteger('alarm_id')->nullable();
            $table->foreignId('reported_by')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->foreignId('assigned_to')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->foreignId('downtime_reason_id')->nullable()->constrained('downtime_reason_codes')->nullOnDelete();
            $table->string('type')->default('preventive');
            $table->string('status')->default('open');
            $table->string('priority')->default('medium');
            $table->text('description')->nullable();
            $table->text('cause')->nullable();
            $table->text('resolution')->nullable();
            $table->decimal('meter_reading', 12, 2)->nullable();
            $table->timestamp('due_at')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->boolean('auto_generated')->default(false);
            $table->decimal('total_cost', 12, 2)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });

        Schema::create('pm_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->string('schedule_type')->default('time');
            $table->integer('interval_value')->nullable();
            $table->string('interval_unit')->nullable();
            $table->string('meter_type')->nullable();
            $table->decimal('last_meter_reading', 12, 2)->nullable();
            $table->decimal('next_meter_reading', 12, 2)->nullable();
            $table->date('last_service_at')->nullable();
            $table->date('next_due_at')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        Schema::create('downtime_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->constrained()->cascadeOnDelete();
            $table->foreignId('work_order_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('reason_code_id')->nullable()->constrained('downtime_reason_codes')->nullOnDelete();
            $table->timestamp('started_at');
            $table->timestamp('ended_at')->nullable();
            $table->integer('duration_minutes')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        Schema::create('work_order_costs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('work_order_id')->constrained()->cascadeOnDelete();
            $table->string('type');
            $table->string('description')->nullable();
            $table->decimal('quantity', 12, 2)->nullable();
            $table->decimal('unit_cost', 12, 2)->nullable();
            $table->decimal('total_cost', 12, 2)->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('work_order_costs');
        Schema::dropIfExists('downtime_logs');
        Schema::dropIfExists('pm_schedules');
        Schema::dropIfExists('work_orders');
        Schema::dropIfExists('downtime_reason_codes');
        Schema::dropIfExists('checklists');
    }
};
