<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('devices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->nullable()->constrained()->nullOnDelete();
            $table->string('name')->nullable();
            $table->string('type')->nullable();
            $table->string('identifier')->nullable();
            $table->json('meta')->nullable();
            $table->timestamp('last_seen_at')->nullable();
            $table->timestamps();
        });

        Schema::create('sensor_events_raw', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('device_id')->constrained()->cascadeOnDelete();
            $table->json('payload');
            $table->timestamp('occurred_at');
            $table->timestamps();
        });

        Schema::create('sensor_metrics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->constrained()->cascadeOnDelete();
            $table->string('metric');
            $table->decimal('value', 12, 4)->nullable();
            $table->string('unit')->nullable();
            $table->string('source')->nullable();
            $table->timestamp('occurred_at')->nullable();
            $table->timestamps();
        });

        Schema::create('meter_readings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->constrained()->cascadeOnDelete();
            $table->string('meter_type');
            $table->decimal('value', 12, 2);
            $table->string('source')->nullable();
            $table->timestamp('recorded_at')->nullable();
            $table->timestamps();
        });

        Schema::create('gps_points', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('device_id')->nullable()->constrained()->nullOnDelete();
            $table->decimal('latitude', 10, 6);
            $table->decimal('longitude', 10, 6);
            $table->decimal('speed', 8, 2)->nullable();
            $table->decimal('heading', 8, 2)->nullable();
            $table->timestamp('occurred_at')->nullable();
            $table->timestamps();
        });

        Schema::create('alarm_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->string('metric')->nullable();
            $table->string('comparison')->nullable();
            $table->decimal('threshold', 12, 4)->nullable();
            $table->string('severity')->default('warning');
            $table->json('conditions')->nullable();
            $table->json('schedule')->nullable();
            $table->json('actions')->nullable();
            $table->boolean('enabled')->default(true);
            $table->foreignId('created_by')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->timestamps();
        });

        Schema::create('alarms', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('rule_id')->nullable()->constrained('alarm_rules')->nullOnDelete();
            $table->foreignId('work_order_id')->nullable()->constrained()->nullOnDelete();
            $table->string('severity')->default('warning');
            $table->string('status')->default('open');
            $table->text('message')->nullable();
            $table->timestamp('triggered_at')->nullable();
            $table->foreignId('acknowledged_by')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->timestamp('acknowledged_at')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('alarms');
        Schema::dropIfExists('alarm_rules');
        Schema::dropIfExists('gps_points');
        Schema::dropIfExists('meter_readings');
        Schema::dropIfExists('sensor_metrics');
        Schema::dropIfExists('sensor_events_raw');
        Schema::dropIfExists('devices');
    }
};
