<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('import_batches', function (Blueprint $table) {
            $table->string('import_type')->default('assets')->after('id');
            $table->text('ai_summary')->nullable()->after('summary');
            $table->timestamp('processed_at')->nullable()->after('ai_summary');
        });

        Schema::table('work_orders', function (Blueprint $table) {
            $table->string('reference_code')->nullable()->after('id');
            $table->string('source')->nullable()->after('reference_code');
            $table->unique(['tenant_id', 'reference_code']);
        });
    }

    public function down()
    {
        Schema::table('work_orders', function (Blueprint $table) {
            $table->dropUnique(['tenant_id', 'reference_code']);
            $table->dropColumn(['reference_code', 'source']);
        });

        Schema::table('import_batches', function (Blueprint $table) {
            $table->dropColumn(['import_type', 'ai_summary', 'processed_at']);
        });
    }
};
