<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('assets', function (Blueprint $table) {
            $table->boolean('fit_for_purpose')->nullable()->after('status');
            $table->text('plant_restrictions')->nullable()->after('fit_for_purpose');
            $table->text('comments')->nullable()->after('plant_restrictions');
            $table->string('service_frequency')->nullable()->after('maintenance_interval');
            $table->date('next_review_at')->nullable()->after('service_frequency');
            $table->string('source')->nullable()->after('next_review_at');
            $table->string('spare_tags')->nullable()->after('source');
            $table->text('top_spares')->nullable()->after('spare_tags');
            $table->decimal('yearly_budget', 12, 2)->nullable()->after('top_spares');
            $table->decimal('daily_budget', 12, 2)->nullable()->after('yearly_budget');
            $table->decimal('weekly_budget', 12, 2)->nullable()->after('daily_budget');
            $table->decimal('monthly_budget', 12, 2)->nullable()->after('weekly_budget');
        });

        Schema::table('parts', function (Blueprint $table) {
            $table->string('stage_of_use')->nullable()->after('category');
            $table->string('replacement_frequency')->nullable()->after('stage_of_use');
            $table->decimal('estimated_replacements_per_year', 12, 2)->nullable()->after('replacement_frequency');
            $table->decimal('cost_per_year', 12, 2)->nullable()->after('estimated_replacements_per_year');
        });

        Schema::table('inventory_items', function (Blueprint $table) {
            $table->decimal('unit_cost', 12, 2)->nullable()->after('quantity');
            $table->decimal('total_cost', 12, 2)->nullable()->after('unit_cost');
        });

        Schema::create('asset_spares', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('asset_id')->constrained()->cascadeOnDelete();
            $table->foreignId('part_id')->constrained()->cascadeOnDelete();
            $table->decimal('quantity', 12, 2)->nullable();
            $table->decimal('unit_cost', 12, 2)->nullable();
            $table->string('replacement_frequency')->nullable();
            $table->decimal('estimated_replacements_per_year', 12, 2)->nullable();
            $table->decimal('cost_per_year', 12, 2)->nullable();
            $table->timestamps();
            $table->unique(['tenant_id', 'asset_id', 'part_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('asset_spares');

        Schema::table('inventory_items', function (Blueprint $table) {
            $table->dropColumn(['unit_cost', 'total_cost']);
        });

        Schema::table('parts', function (Blueprint $table) {
            $table->dropColumn([
                'stage_of_use',
                'replacement_frequency',
                'estimated_replacements_per_year',
                'cost_per_year',
            ]);
        });

        Schema::table('assets', function (Blueprint $table) {
            $table->dropColumn([
                'fit_for_purpose',
                'plant_restrictions',
                'comments',
                'service_frequency',
                'next_review_at',
                'source',
                'spare_tags',
                'top_spares',
                'yearly_budget',
                'daily_budget',
                'weekly_budget',
                'monthly_budget',
            ]);
        });
    }
};
