<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('purchase_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('site_id')->nullable()->constrained()->nullOnDelete();
            $table->string('request_code');
            $table->string('title')->nullable();
            $table->string('status')->default('pending');
            $table->string('priority')->default('medium');
            $table->foreignId('requested_by')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->date('needed_by')->nullable();
            $table->decimal('total_estimated_cost', 14, 2)->nullable();
            $table->string('currency', 8)->default('USD');
            $table->text('notes')->nullable();
            $table->string('source_file')->nullable();
            $table->timestamps();

            $table->unique(['tenant_id', 'request_code']);
        });

        Schema::create('purchase_request_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('purchase_request_id')->constrained()->cascadeOnDelete();
            $table->integer('line_number')->nullable();
            $table->string('item_name')->nullable();
            $table->decimal('quantity', 12, 2)->nullable();
            $table->string('unit')->nullable();
            $table->string('purpose_cost_center')->nullable();
            $table->date('date_initiated')->nullable();
            $table->string('supplier_name')->nullable();
            $table->string('quote_number')->nullable();
            $table->decimal('quote_amount_usd', 14, 2)->nullable();
            $table->decimal('quote_amount_zwl', 14, 2)->nullable();
            $table->string('selected_supplier')->nullable();
            $table->text('comments')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('purchase_request_items');
        Schema::dropIfExists('purchase_requests');
    }
};
