<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('document_intake_batches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('conversation_id')->nullable()->constrained('chat_conversations')->nullOnDelete();
            $table->foreignId('user_id')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->string('doc_type')->nullable();
            $table->string('status')->default('pending');
            $table->string('schema_version')->nullable();
            $table->json('summary')->nullable();
            $table->json('warnings')->nullable();
            $table->json('source_upload_ids')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
        });

        Schema::create('document_intake_rows', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('batch_id')->constrained('document_intake_batches')->cascadeOnDelete();
            $table->integer('row_index')->nullable();
            $table->json('data')->nullable();
            $table->json('errors')->nullable();
            $table->json('warnings')->nullable();
            $table->json('matches')->nullable();
            $table->string('status')->default('pending');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('document_intake_rows');
        Schema::dropIfExists('document_intake_batches');
    }
};
