<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('audit_logs', function (Blueprint $table) {
            if (!Schema::hasColumn('audit_logs', 'channel')) {
                $table->string('channel')->nullable()->after('user_id');
            }
            if (!Schema::hasColumn('audit_logs', 'payload_json')) {
                $table->json('payload_json')->nullable()->after('changes');
            }
        });
    }

    public function down(): void
    {
        Schema::table('audit_logs', function (Blueprint $table) {
            if (Schema::hasColumn('audit_logs', 'channel')) {
                $table->dropColumn('channel');
            }
            if (Schema::hasColumn('audit_logs', 'payload_json')) {
                $table->dropColumn('payload_json');
            }
        });
    }
};
