<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('work_orders', function (Blueprint $table) {
            $table->timestamp('accepted_at')->nullable()->after('started_at');
            $table->decimal('progress_percent', 5, 2)->nullable()->after('accepted_at');
            $table->decimal('estimated_cost', 12, 2)->nullable()->after('progress_percent');
            $table->boolean('requires_approval')->default(false)->after('estimated_cost');
            $table->string('approval_status')->nullable()->after('requires_approval');
            $table->foreignId('approved_by')->nullable()->references('id')->on('users')->nullOnDelete()->after('approval_status');
            $table->timestamp('approved_at')->nullable()->after('approved_by');
            $table->timestamp('planned_start')->nullable()->after('approved_at');
        });
    }

    public function down()
    {
        Schema::table('work_orders', function (Blueprint $table) {
            $table->dropForeign(['approved_by']);
            $table->dropColumn([
                'accepted_at',
                'progress_percent',
                'estimated_cost',
                'requires_approval',
                'approval_status',
                'approved_by',
                'approved_at',
                'planned_start',
            ]);
        });
    }
};
