<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            $table->string('department')->nullable()->after('title');
            $table->string('cost_center')->nullable()->after('department');
            $table->timestamp('submitted_at')->nullable()->after('needed_by');
            $table->timestamp('approved_at')->nullable()->after('submitted_at');
        });

        Schema::table('purchase_request_items', function (Blueprint $table) {
            $table->foreignId('part_id')->nullable()->after('purchase_request_id')->constrained('parts')->nullOnDelete();
            $table->string('sku')->nullable()->after('part_id');
            $table->string('description')->nullable()->after('item_name');
            $table->decimal('est_unit_cost', 14, 2)->nullable()->after('quantity');
            $table->string('preferred_vendor')->nullable()->after('supplier_name');
        });

        Schema::create('purchase_request_approvals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('purchase_request_id')->constrained()->cascadeOnDelete();
            $table->unsignedInteger('step');
            $table->foreignId('approver_id')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->string('status')->default('pending');
            $table->text('notes')->nullable();
            $table->timestamp('decided_at')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('purchase_request_approvals');

        Schema::table('purchase_request_items', function (Blueprint $table) {
            $table->dropForeign(['part_id']);
            $table->dropColumn(['part_id', 'sku', 'description', 'est_unit_cost', 'preferred_vendor']);
        });

        Schema::table('purchase_requests', function (Blueprint $table) {
            $table->dropColumn(['department', 'cost_center', 'submitted_at', 'approved_at']);
        });
    }
};
