<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('telegram_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('site_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('asset_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('work_order_id')->nullable()->constrained('work_orders')->nullOnDelete();
            $table->string('event_code');
            $table->string('event_type');
            $table->string('severity')->default('info');
            $table->string('title')->nullable();
            $table->text('message')->nullable();
            $table->json('payload')->nullable();
            $table->string('status')->default('open');
            $table->foreignId('acked_by')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->timestamp('acked_at')->nullable();
            $table->timestamp('snoozed_until')->nullable();
            $table->unsignedInteger('escalation_level')->default(0);
            $table->timestamp('last_escalated_at')->nullable();
            $table->string('dedupe_key')->nullable();
            $table->timestamps();

            $table->unique(['tenant_id', 'event_code']);
            $table->unique(['tenant_id', 'dedupe_key']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('telegram_events');
    }
};
