<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('telegram_event_messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('telegram_event_id')->constrained('telegram_events')->cascadeOnDelete();
            $table->string('chat_id');
            $table->string('message_id')->nullable();
            $table->string('status')->default('sent');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('telegram_event_messages');
    }
};
