<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            $table->timestamp('last_reminded_at')->nullable()->after('approved_at');
        });

        Schema::table('work_orders', function (Blueprint $table) {
            $table->timestamp('last_reminded_at')->nullable()->after('planned_start');
        });
    }

    public function down()
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            $table->dropColumn('last_reminded_at');
        });

        Schema::table('work_orders', function (Blueprint $table) {
            $table->dropColumn('last_reminded_at');
        });
    }
};
