<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('agent_notifications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id')->index();
            $table->string('agent_key', 64)->index();
            $table->string('agent_name', 120);
            $table->string('severity', 24)->default('info');
            $table->string('title', 200);
            $table->text('summary')->nullable();
            $table->json('payload')->nullable();
            $table->json('recipients')->nullable();
            $table->string('status', 24)->default('queued');
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('agent_notifications');
    }
};
