<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('weekly_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id')->index();
            $table->string('report_week', 16)->index();
            $table->dateTime('period_start');
            $table->dateTime('period_end');
            $table->dateTime('generated_at')->nullable();
            $table->string('pdf_path')->nullable();
            $table->json('summary_json')->nullable();
            $table->string('status', 24)->default('generating');
            $table->timestamps();

            $table->unique(['tenant_id', 'report_week']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('weekly_reports');
    }
};
