<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('weekly_report_sections', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('weekly_report_id')->index();
            $table->string('section_code', 64)->index();
            $table->string('title', 200);
            $table->json('content_json')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('weekly_report_sections');
    }
};
