<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('maintenance_cashflow_lines', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('period_type', 32);
            $table->string('period_label', 64)->nullable();
            $table->date('period_start')->nullable();
            $table->date('period_end')->nullable();
            $table->string('category', 120)->nullable();
            $table->decimal('amount_usd', 12, 2)->nullable();
            $table->text('notes')->nullable();
            $table->string('source', 120)->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'period_type']);
            $table->index(['tenant_id', 'period_label']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('maintenance_cashflow_lines');
    }
};
