<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('maintenance_weekly_repairs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('week', 32)->nullable();
            $table->unsignedInteger('priority')->nullable();
            $table->string('asset_ref', 120)->nullable();
            $table->string('category', 120)->nullable();
            $table->text('scope')->nullable();
            $table->decimal('original_usd', 12, 2)->nullable();
            $table->decimal('original_zar', 12, 2)->nullable();
            $table->decimal('fx_rate', 12, 4)->nullable();
            $table->decimal('additionals_usd', 12, 2)->nullable();
            $table->decimal('planned_total_usd', 12, 2)->nullable();
            $table->string('source', 120)->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'week']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('maintenance_weekly_repairs');
    }
};
