<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('maintenance_risk_heatmaps', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('week', 32)->nullable();
            $table->string('overall_risk', 24)->nullable();
            $table->string('safety', 24)->nullable();
            $table->string('compliance', 24)->nullable();
            $table->string('production', 24)->nullable();
            $table->string('financial', 24)->nullable();
            $table->string('reputation', 24)->nullable();
            $table->string('source', 120)->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'week']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('maintenance_risk_heatmaps');
    }
};
