<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('maintenance_risk_registers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('risk_code', 32)->nullable();
            $table->string('week', 32)->nullable();
            $table->string('assets', 180)->nullable();
            $table->text('description')->nullable();
            $table->string('category', 80)->nullable();
            $table->string('likelihood', 32)->nullable();
            $table->string('impact', 32)->nullable();
            $table->string('rating', 32)->nullable();
            $table->text('mitigation')->nullable();
            $table->string('owner', 80)->nullable();
            $table->string('status', 32)->nullable();
            $table->string('source', 120)->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'risk_code']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('maintenance_risk_registers');
    }
};
