<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('reconciliation_links', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->string('source_type', 80);
            $table->unsignedBigInteger('source_id');
            $table->string('target_type', 80)->nullable();
            $table->unsignedBigInteger('target_id')->nullable();
            $table->decimal('confidence', 5, 2)->default(0);
            $table->string('status', 24)->default('suggested');
            $table->string('reason', 190)->nullable();
            $table->json('meta_json')->nullable();
            $table->unsignedBigInteger('applied_by')->nullable();
            $table->timestamp('applied_at')->nullable();
            $table->timestamp('notified_at')->nullable();
            $table->string('notified_channel', 24)->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'source_type', 'source_id']);
            $table->index(['tenant_id', 'target_type', 'target_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reconciliation_links');
    }
};
