<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasColumn('work_orders', 'pm_schedule_id')) {
            Schema::table('work_orders', function (Blueprint $table) {
                $table->foreignId('pm_schedule_id')->nullable()->after('asset_id')->constrained('pm_schedules')->nullOnDelete();
            });
        }

        if (!Schema::hasColumn('goods_receipts', 'purchase_request_id')) {
            Schema::table('goods_receipts', function (Blueprint $table) {
                $table->foreignId('purchase_request_id')->nullable()->after('purchase_order_id')->constrained('purchase_requests')->nullOnDelete();
            });
        }

        Schema::table('maintenances', function (Blueprint $table) {
            if (!Schema::hasColumn('maintenances', 'pm_schedule_id')) {
                $table->foreignId('pm_schedule_id')->nullable()->after('asset_id')->constrained('pm_schedules')->nullOnDelete();
            }
            if (!Schema::hasColumn('maintenances', 'work_order_id')) {
                $table->foreignId('work_order_id')->nullable()->after('pm_schedule_id')->constrained('work_orders')->nullOnDelete();
            }
            if (!Schema::hasColumn('maintenances', 'meter_reading_id')) {
                $table->foreignId('meter_reading_id')->nullable()->after('work_order_id')->constrained('meter_readings')->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        if (Schema::hasColumn('work_orders', 'pm_schedule_id')) {
            Schema::table('work_orders', function (Blueprint $table) {
                $table->dropConstrainedForeignId('pm_schedule_id');
            });
        }

        if (Schema::hasColumn('goods_receipts', 'purchase_request_id')) {
            Schema::table('goods_receipts', function (Blueprint $table) {
                $table->dropConstrainedForeignId('purchase_request_id');
            });
        }

        Schema::table('maintenances', function (Blueprint $table) {
            if (Schema::hasColumn('maintenances', 'pm_schedule_id')) {
                $table->dropConstrainedForeignId('pm_schedule_id');
            }
            if (Schema::hasColumn('maintenances', 'work_order_id')) {
                $table->dropConstrainedForeignId('work_order_id');
            }
            if (Schema::hasColumn('maintenances', 'meter_reading_id')) {
                $table->dropConstrainedForeignId('meter_reading_id');
            }
        });
    }
};
