<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('devices', function (Blueprint $table) {
            if (!Schema::hasColumn('devices', 'house_id')) {
                $table->foreignId('house_id')->nullable()->constrained('houses')->nullOnDelete();
            }
            if (!Schema::hasColumn('devices', 'api_key')) {
                $table->string('api_key', 64)->nullable()->unique();
            }
            if (!Schema::hasColumn('devices', 'firmware_version')) {
                $table->string('firmware_version')->nullable();
            }
        });

        Schema::table('ai_reports', function (Blueprint $table) {
            if (!Schema::hasColumn('ai_reports', 'house_id')) {
                $table->foreignId('house_id')->nullable()->constrained('houses')->nullOnDelete();
            }
            if (!Schema::hasColumn('ai_reports', 'period')) {
                $table->string('period')->nullable();
            }
            if (!Schema::hasColumn('ai_reports', 'report_text')) {
                $table->text('report_text')->nullable();
            }
            if (!Schema::hasColumn('ai_reports', 'metrics_json')) {
                $table->json('metrics_json')->nullable();
            }
        });
    }

    public function down()
    {
        Schema::table('ai_reports', function (Blueprint $table) {
            if (Schema::hasColumn('ai_reports', 'metrics_json')) {
                $table->dropColumn('metrics_json');
            }
            if (Schema::hasColumn('ai_reports', 'report_text')) {
                $table->dropColumn('report_text');
            }
            if (Schema::hasColumn('ai_reports', 'period')) {
                $table->dropColumn('period');
            }
            if (Schema::hasColumn('ai_reports', 'house_id')) {
                $table->dropConstrainedForeignId('house_id');
            }
        });

        Schema::table('devices', function (Blueprint $table) {
            if (Schema::hasColumn('devices', 'firmware_version')) {
                $table->dropColumn('firmware_version');
            }
            if (Schema::hasColumn('devices', 'api_key')) {
                $table->dropUnique(['api_key']);
                $table->dropColumn('api_key');
            }
            if (Schema::hasColumn('devices', 'house_id')) {
                $table->dropConstrainedForeignId('house_id');
            }
        });
    }
};
