-- Sample data for testing (SQLite/MySQL compatible inserts)
-- Assumes migrations have been run and tables are empty.

BEGIN TRANSACTION;

INSERT INTO tenants (id, name, email, password, subdomain, database_name, subscription_plan, status, created_at, updated_at)
VALUES
    (1, 'Iron Ridge Mining', 'ops@ironridge.example', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'iron-ridge', NULL, 'enterprise', 'active', '2026-01-10 09:00:00', '2026-01-10 09:00:00'),
    (2, 'Atlas Quarry', 'ops@atlasquarry.example', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'atlas-quarry', NULL, 'pro', 'active', '2026-01-10 09:05:00', '2026-01-10 09:05:00');

INSERT INTO users (id, tenant_id, name, email, email_verified_at, password, remember_token, created_at, updated_at)
VALUES
    (1, 1, 'Jade Ramos', 'jade@ironridge.example', '2026-01-10 09:10:00', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', NULL, '2026-01-10 09:10:00', '2026-01-10 09:10:00'),
    (2, 1, 'Marcus Lee', 'marcus@ironridge.example', '2026-01-10 09:12:00', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', NULL, '2026-01-10 09:12:00', '2026-01-10 09:12:00'),
    (3, 2, 'Priya Nair', 'priya@atlasquarry.example', '2026-01-10 09:14:00', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', NULL, '2026-01-10 09:14:00', '2026-01-10 09:14:00'),
    (4, 2, 'Daniel Cho', 'daniel@atlasquarry.example', '2026-01-10 09:16:00', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', NULL, '2026-01-10 09:16:00', '2026-01-10 09:16:00');

INSERT INTO assets (id, tenant_id, name, description, status, purchase_date, warranty_expiry, location, current_value, maintenance_interval, created_at, updated_at, deleted_at)
VALUES
    (1, 1, 'Excavator EX-12', 'Primary digger for North Ridge', 'active', '2024-06-12', '2027-06-12', 'North Ridge', 1250000.00, 400, '2026-01-10 09:20:00', '2026-01-10 09:20:00', NULL),
    (2, 1, 'Crusher C-6', 'Ore processing unit', 'active', '2023-03-05', '2026-03-05', 'East Yard', 860000.00, 350, '2026-01-10 09:22:00', '2026-01-10 09:22:00', NULL),
    (3, 2, 'Conveyor CV-3', 'Material transport line', 'active', '2022-08-18', '2025-08-18', 'West Pit', 410000.00, 300, '2026-01-10 09:24:00', '2026-01-10 09:24:00', NULL),
    (4, 2, 'Loader L-7', 'Front loader for yard operations', 'inactive', '2021-11-02', '2024-11-02', 'Atlas South', 295000.00, 280, '2026-01-10 09:26:00', '2026-01-10 09:26:00', NULL);

INSERT INTO vehicles (id, tenant_id, name, type, license_plate, status, telemetry_data, maintenance_schedule, created_at, updated_at)
VALUES
    (1, 1, 'Hauler H-18', 'truck', 'IRH18A', 'active', '{"last_signal":"2026-01-10T09:30:00Z"}', '{"next_service":"2026-02-10"}', '2026-01-10 09:30:00', '2026-01-10 09:30:00'),
    (2, 1, 'Dump Truck D-9', 'truck', 'IRD09B', 'idle', '{"last_signal":"2026-01-10T09:28:00Z"}', '{"next_service":"2026-02-02"}', '2026-01-10 09:32:00', '2026-01-10 09:32:00'),
    (3, 2, 'Hauler A-44', 'truck', 'ATQ44C', 'active', '{"last_signal":"2026-01-10T09:27:00Z"}', '{"next_service":"2026-02-15"}', '2026-01-10 09:34:00', '2026-01-10 09:34:00'),
    (4, 2, 'Loader L-5', 'loader', 'ATQL5D', 'service', '{"last_signal":"2026-01-10T09:25:00Z"}', '{"next_service":"2026-01-20"}', '2026-01-10 09:36:00', '2026-01-10 09:36:00');

INSERT INTO trips (id, tenant_id, vehicle_id, start_location, end_location, start_time, end_time, distance, status, created_at, updated_at)
VALUES
    (1, 1, 1, 'North Ridge', 'Processing Plant', '2026-01-10 08:40:00', '2026-01-10 08:58:00', 18.40, 'completed', '2026-01-10 08:40:00', '2026-01-10 08:58:00'),
    (2, 1, 2, 'East Yard', 'North Ridge', '2026-01-10 09:05:00', NULL, 9.10, 'active', '2026-01-10 09:05:00', '2026-01-10 09:05:00'),
    (3, 2, 3, 'West Pit', 'Atlas South', '2026-01-10 08:55:00', '2026-01-10 09:25:00', 14.70, 'completed', '2026-01-10 08:55:00', '2026-01-10 09:25:00'),
    (4, 2, 4, 'Atlas South', 'West Pit', '2026-01-10 09:15:00', NULL, 6.50, 'active', '2026-01-10 09:15:00', '2026-01-10 09:15:00');

INSERT INTO maintenances (id, asset_id, scheduled_date, completed_date, status, description, notes, usage_hours, created_at, updated_at)
VALUES
    (1, 1, '2026-01-12', NULL, 'scheduled', 'Hydraulic inspection', 'Auto-generated by AI', 1240.50, '2026-01-10 09:40:00', '2026-01-10 09:40:00'),
    (2, 2, '2026-01-13', '2026-01-13', 'completed', 'Belt alignment', 'All clear', 980.20, '2026-01-10 09:42:00', '2026-01-13 16:10:00'),
    (3, 3, '2026-01-14', NULL, 'pending', 'Safety inspection', 'Awaiting tech', 760.00, '2026-01-10 09:44:00', '2026-01-10 09:44:00'),
    (4, 4, '2026-01-11', '2026-01-11', 'completed', 'Tire rotation', 'Replaced worn tire', 520.75, '2026-01-10 09:46:00', '2026-01-11 14:30:00');

INSERT INTO telemetries (id, tenant_id, vehicle_id, asset_id, timestamp, usage_hours, data, created_at, updated_at)
VALUES
    (1, 1, 1, 1, '2026-01-10 09:30:00', 1245.10, '{"speed":42,"fuel_level":0.74,"temp":83}', '2026-01-10 09:30:00', '2026-01-10 09:30:00'),
    (2, 1, 2, 2, '2026-01-10 09:28:00', 985.20, '{"speed":0,"fuel_level":0.61,"temp":79}', '2026-01-10 09:28:00', '2026-01-10 09:28:00'),
    (3, 2, 3, 3, '2026-01-10 09:27:00', 770.50, '{"speed":38,"fuel_level":0.68,"temp":81}', '2026-01-10 09:27:00', '2026-01-10 09:27:00'),
    (4, 2, 4, 4, '2026-01-10 09:25:00', 530.10, '{"speed":0,"fuel_level":0.49,"temp":76}', '2026-01-10 09:25:00', '2026-01-10 09:25:00');

COMMIT;
