<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\Site;
use App\Models\Tenant;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class FourwaysProfilesSeeder extends Seeder
{
    public function run(): void
    {
        $tenant = Tenant::where('name', 'Fourways Group')->first() ?? Tenant::first();
        if (!$tenant) {
            return;
        }

        $defaultSiteId = Site::where('tenant_id', $tenant->id)->orderBy('id')->value('id');

        $roles = [
            'Admin',
            'Maintenance',
            'Operator',
            'Stores',
            'Safety',
            'Finance',
            'Viewer',
            'Managing Director',
            'Engineering Manager',
            'Engineer',
            'Foreman',
            'Artisan',
            'Planner',
            'Accountant',
            'Finance Manager',
        ];

        foreach ($roles as $name) {
            Role::firstOrCreate([
                'tenant_id' => $tenant->id,
                'name' => $name,
            ]);
        }

        $defaultPassword = Hash::make('password');
        $profiles = [
            ['name' => 'Tendai Moyo', 'email' => 'md@fourways.example', 'role' => 'Managing Director', 'site_id' => null],
            ['name' => 'Faith Ncube', 'email' => 'engineering.manager@fourways.example', 'role' => 'Engineering Manager', 'site_id' => $defaultSiteId],
            ['name' => 'Leon Chikowore', 'email' => 'engineer@fourways.example', 'role' => 'Engineer', 'site_id' => $defaultSiteId],
            ['name' => 'Sibusiso Dube', 'email' => 'foreman@fourways.example', 'role' => 'Foreman', 'site_id' => $defaultSiteId],
            ['name' => 'Nomsa Zulu', 'email' => 'artisan@fourways.example', 'role' => 'Artisan', 'site_id' => $defaultSiteId],
            ['name' => 'Tariro Banda', 'email' => 'planner@fourways.example', 'role' => 'Planner', 'site_id' => $defaultSiteId],
            ['name' => 'Kevin Mhlanga', 'email' => 'accountant@fourways.example', 'role' => 'Accountant', 'site_id' => null],
            ['name' => 'Joyce Mutasa', 'email' => 'operator@fourways.example', 'role' => 'Operator', 'site_id' => $defaultSiteId],
            ['name' => 'Alfred Chirwa', 'email' => 'finance.manager@fourways.example', 'role' => 'Finance Manager', 'site_id' => null],
        ];

        foreach ($profiles as $profile) {
            $user = User::firstOrCreate(
                ['email' => $profile['email']],
                [
                    'tenant_id' => $tenant->id,
                    'name' => $profile['name'],
                    'password' => $defaultPassword,
                    'site_id' => $profile['site_id'],
                ]
            );

            if (!$user->tenant_id) {
                $user->tenant_id = $tenant->id;
                $user->site_id = $profile['site_id'];
                $user->save();
            }

            $role = Role::where('tenant_id', $tenant->id)
                ->where('name', $profile['role'])
                ->first();

            if ($role) {
                $user->roles()->syncWithoutDetaching([$role->id]);
            }
        }
    }
}
