# API Documentation for Laravel AI Asset & Fleet Management SaaS

## Overview
This document outlines the API endpoints available in the Laravel AI Asset & Fleet Management SaaS application. The API is designed to facilitate multi-tenant asset and fleet management, including tenant management, asset lifecycle tracking, maintenance scheduling, telematics data ingestion, and AI-driven automation.

## Base URL
```
http://your-domain.com/api
```

## Authentication
All API requests require authentication. Use the following method to obtain a token:

### Login
- **Endpoint:** `/auth/login`
- **Method:** POST
- **Request Body:**
  ```json
  {
    "email": "user@example.com",
    "password": "yourpassword"
  }
  ```
- **Response:**
  ```json
  {
    "token": "your_jwt_token"
  }
  ```

## Tenant Management
### Create Tenant
- **Endpoint:** `/tenants`
- **Method:** POST
- **Request Body:**
  ```json
  {
    "name": "Tenant Name",
    "email": "tenant@example.com",
    "password": "tenantpassword"
  }
  ```
- **Response:**
  ```json
  {
    "message": "Tenant created successfully.",
    "tenant": {
      "id": 1,
      "name": "Tenant Name"
    }
  }
  ```

### Get Tenants
- **Endpoint:** `/tenants`
- **Method:** GET
- **Response:**
  ```json
  [
    {
      "id": 1,
      "name": "Tenant Name"
    }
  ]
  ```

## Asset Management
### Register Asset
- **Endpoint:** `/assets`
- **Method:** POST
- **Request Body:**
  ```json
  {
    "name": "Asset Name",
    "type": "Excavator",
    "tenant_id": 1
  }
  ```
- **Response:**
  ```json
  {
    "message": "Asset registered successfully.",
    "asset": {
      "id": 1,
      "name": "Asset Name"
    }
  }
  ```

### Get Assets
- **Endpoint:** `/assets`
- **Method:** GET
- **Response:**
  ```json
  [
    {
      "id": 1,
      "name": "Asset Name",
      "type": "Excavator"
    }
  ]
  ```

## Vehicle Management
### Register Vehicle
- **Endpoint:** `/vehicles`
- **Method:** POST
- **Request Body:**
  ```json
  {
    "license_plate": "ABC123",
    "tenant_id": 1
  }
  ```
- **Response:**
  ```json
  {
    "message": "Vehicle registered successfully.",
    "vehicle": {
      "id": 1,
      "license_plate": "ABC123"
    }
  }
  ```

### Get Vehicles
- **Endpoint:** `/vehicles`
- **Method:** GET
- **Response:**
  ```json
  [
    {
      "id": 1,
      "license_plate": "ABC123"
    }
  ]
  ```

## Telemetry Data
### Ingest Telemetry Data
- **Endpoint:** `/telemetry`
- **Method:** POST
- **Request Body:**
  ```json
  {
    "vehicle_id": 1,
    "data": {
      "speed": 60,
      "fuel_level": 75
    }
  }
  ```
- **Response:**
  ```json
  {
    "message": "Telemetry data ingested successfully."
  }
  ```

## Maintenance Scheduling
### Schedule Maintenance
- **Endpoint:** `/maintenance`
- **Method:** POST
- **Request Body:**
  ```json
  {
    "asset_id": 1,
    "scheduled_date": "2023-12-01",
    "description": "Oil change"
  }
  ```
- **Response:**
  ```json
  {
    "message": "Maintenance scheduled successfully."
  }
  ```

## AI Automation
### Trigger AI Automation
- **Endpoint:** `/ai/trigger`
- **Method:** POST
- **Request Body:**
  ```json
  {
    "asset_id": 1,
    "action": "predict_failure"
  }
  ```
- **Response:**
  ```json
  {
    "message": "AI automation triggered successfully."
  }
  ```

## Error Handling
All error responses will return a JSON object with the following structure:
```json
{
  "error": {
    "message": "Error message here.",
    "code": 400
  }
}
```

## Conclusion
This API documentation provides a comprehensive overview of the endpoints available for managing tenants, assets, vehicles, telemetry data, maintenance, and AI-driven automation in the Laravel AI Asset & Fleet Management SaaS application. For further details, please refer to the respective controller methods and services.