"use strict";

var _fs = _interopRequireDefault(require("fs"));

var _url = _interopRequireDefault(require("url"));

var _transform = require("./transform");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Node < 18.6: defaultResolve takes 3 arguments.
// Node >= 18.6: nextResolve from the chain takes 2 arguments.
async function resolve(specifier, context, defaultResolve) {
  if (context.parentURL && context.parentURL.startsWith('file://')) {
    const filename = _url.default.fileURLToPath(context.parentURL);

    const resolved = (0, _transform.resolveHook)(filename, specifier);
    if (resolved !== undefined) specifier = _url.default.pathToFileURL(resolved).toString();
  }

  return defaultResolve(specifier, context, defaultResolve);
} // Node < 18.6: defaultLoad takes 3 arguments.
// Node >= 18.6: nextLoad from the chain takes 2 arguments.


async function load(moduleUrl, context, defaultLoad) {
  // Bail out for wasm, json, etc.
  // non-js files have context.format === undefined
  if (context.format !== 'commonjs' && context.format !== 'module' && context.format !== undefined) return defaultLoad(moduleUrl, context, defaultLoad); // Bail for built-in modules.

  if (!moduleUrl.startsWith('file://')) return defaultLoad(moduleUrl, context, defaultLoad);

  const filename = _url.default.fileURLToPath(moduleUrl); // Bail for node_modules.


  if ((0, _transform.belongsToNodeModules)(filename)) return defaultLoad(moduleUrl, context, defaultLoad);

  const code = _fs.default.readFileSync(filename, 'utf-8');

  const source = (0, _transform.transformHook)(code, filename, moduleUrl); // Output format is always the same as input format, if it was unknown, we always report modules.
  // shortCurcuit is required by Node >= 18.6 to designate no more loaders should be called.

  return {
    format: context.format || 'module',
    source,
    shortCircuit: true
  };
}

module.exports = {
  resolve,
  load
};