"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addRunnerPlugin = void 0;
Object.defineProperty(exports, "gitCommitInfo", {
  enumerable: true,
  get: function () {
    return _gitCommitInfoPlugin.gitCommitInfo;
  }
});
exports.setRunnerToAddPluginsTo = void 0;
Object.defineProperty(exports, "webServer", {
  enumerable: true,
  get: function () {
    return _webServerPlugin.webServer;
  }
});

var _webServerPlugin = require("./webServerPlugin");

var _gitCommitInfoPlugin = require("./gitCommitInfoPlugin");

/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
let runnerInstanceToAddPluginsTo;

const setRunnerToAddPluginsTo = runner => {
  runnerInstanceToAddPluginsTo = runner;
};

exports.setRunnerToAddPluginsTo = setRunnerToAddPluginsTo;

const addRunnerPlugin = plugin => {
  // Only present in runner, absent in worker.
  if (runnerInstanceToAddPluginsTo) {
    plugin = typeof plugin === 'function' ? plugin() : plugin;
    runnerInstanceToAddPluginsTo.addPlugin(plugin);
  }
};

exports.addRunnerPlugin = addRunnerPlugin;