// @ts-check
const { devices } = require('@playwright/test');

module.exports = {
    testDir: './tests/e2e',
    timeout: 30_000,
    workers: 1,
    fullyParallel: false,
    expect: {
        timeout: 7_000,
    },
    reporter: 'list',
    use: {
        baseURL: 'http://127.0.0.1:8090',
        trace: 'on-first-retry',
        screenshot: 'only-on-failure',
        video: 'off',
        actionTimeout: 10_000,
        navigationTimeout: 30_000,
    },
    webServer: {
        command: 'tools\\php-8.2.30\\php.exe artisan serve --host=127.0.0.1 --port=8090',
        url: 'http://127.0.0.1:8090/ui',
        timeout: 120_000,
        reuseExistingServer: true,
    },
    projects: [
        {
            name: 'chromium',
            use: {
                browserName: 'chromium',
                viewport: { width: 1366, height: 900 },
            },
        },
        {
            name: 'mobile-chromium',
            use: {
                ...devices['Pixel 5'],
            },
        },
    ],
};
