<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Purchase Request {{ $request->request_code }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111827; }
        .header { display: flex; align-items: center; gap: 16px; margin-bottom: 16px; }
        .logo { height: 48px; }
        h1 { font-size: 20px; margin: 0; }
        .meta { font-size: 12px; color: #4b5563; margin-bottom: 12px; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { border: 1px solid #e5e7eb; padding: 8px; text-align: left; }
        th { background: #111827; color: #fff; }
        .watermark { position: fixed; top: 30%; left: 20%; width: 60%; opacity: 0.08; z-index: -1; }
    </style>
</head>
<body>
    @if ($logo)
        <img class="watermark" src="{{ $logo }}" alt="Watermark">
    @endif
    <div class="header">
        @if ($logo)
            <img class="logo" src="{{ $logo }}" alt="Logo">
        @endif
        <div>
            <h1>Purchase Request {{ $request->request_code }}</h1>
            <div class="meta">Site: {{ $request->site?->name ?? 'Unassigned' }} | Status: {{ ucfirst($request->status ?? 'pending') }}</div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Item</th>
                <th>Qty</th>
                <th>Unit</th>
                <th>USD</th>
                <th>ZWL</th>
                <th>Supplier</th>
                <th>Comments</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($request->items as $item)
                <tr>
                    <td>{{ $item->item_name ?? 'Item' }}</td>
                    <td>{{ $item->quantity ?? '-' }}</td>
                    <td>{{ $item->unit ?? '-' }}</td>
                    <td>{{ $item->quote_amount_usd ?? '-' }}</td>
                    <td>{{ $item->quote_amount_zwl ?? '-' }}</td>
                    <td>{{ $item->selected_supplier ?? $item->supplier_name ?? '-' }}</td>
                    <td>{{ $item->comments ?? '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
