<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111827; }
        .header { display: flex; align-items: center; gap: 16px; margin-bottom: 16px; }
        .logo { height: 48px; }
        h1 { font-size: 20px; margin: 0; }
        .subtitle { font-size: 12px; color: #4b5563; margin-top: 4px; }
        .meta { margin-top: 8px; font-size: 12px; color: #374151; }
        .meta-row { display: flex; gap: 8px; margin-top: 4px; }
        .meta-label { min-width: 120px; color: #6b7280; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; margin-top: 16px; }
        th, td { border: 1px solid #e5e7eb; padding: 8px; text-align: left; }
        th { background: #111827; color: #fff; }
        .watermark { position: fixed; top: 30%; left: 20%; width: 60%; opacity: 0.08; z-index: -1; }
        .watermark-text { position: fixed; top: 38%; left: 0; width: 100%; text-align: center; font-size: 72px; letter-spacing: 6px; color: rgba(17, 24, 39, 0.08); transform: rotate(-20deg); z-index: -2; }
        .section-title { margin-top: 18px; font-size: 13px; font-weight: bold; color: #111827; }
        .status-pill { display: inline-block; padding: 4px 10px; border-radius: 999px; background: #111827; color: #fff; font-size: 11px; text-transform: uppercase; letter-spacing: 0.08em; }
    </style>
</head>
<body>
    @if ($logo)
        <img class="watermark" src="{{ $logo }}" alt="Watermark">
    @endif
    @if (!empty($watermarkText))
        <div class="watermark-text">{{ $watermarkText }}</div>
    @endif
    <div class="header">
        @if ($logo)
            <img class="logo" src="{{ $logo }}" alt="Logo">
        @endif
        <div>
            <h1>{{ $title }}</h1>
            <div class="subtitle">Tenant: {{ $tenant }}</div>
            <div class="subtitle">Requested by: {{ $request->requestedBy?->name ?? '-' }}</div>
            <div class="subtitle"><span class="status-pill">{{ strtoupper($request->status ?? 'draft') }}</span></div>
        </div>
    </div>

    <div class="meta">
        @foreach ($meta as $label => $value)
            <div class="meta-row">
                <span class="meta-label">{{ $label }}</span>
                <span>{{ $value }}</span>
            </div>
        @endforeach
    </div>

    <div class="section-title">Line Items</div>
    <table>
        <thead>
            <tr>
                @foreach ($headers as $header)
                    <th>{{ $header }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach ($rows as $row)
                <tr>
                    @foreach ($row as $cell)
                        <td>{{ $cell }}</td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="section-title">Approvals</div>
    <table>
        <thead>
            <tr>
                <th>Step</th>
                <th>Approver</th>
                <th>Status</th>
                <th>Decided At</th>
                <th>Notes</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($approvals as $approval)
                <tr>
                    <td>{{ $approval['step'] }}</td>
                    <td>{{ $approval['approver'] }}</td>
                    <td>{{ $approval['status'] }}</td>
                    <td>{{ $approval['decided_at'] }}</td>
                    <td>{{ $approval['notes'] }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="5">No approvals recorded.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>
