<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; }
        .slide { width: 960px; height: 540px; padding: 60px; box-sizing: border-box; }
        .logo { height: 56px; margin-bottom: 24px; }
        h1 { font-size: 36px; margin: 0 0 12px; }
        .subtitle { font-size: 18px; color: #374151; margin-bottom: 18px; }
        .meta { font-size: 14px; color: #6b7280; }
        .footer { position: absolute; bottom: 40px; font-size: 12px; color: #6b7280; }
    </style>
</head>
<body>
    <div class="slide">
        @if ($logo)
            <img class="logo" src="{{ $logo }}" alt="Logo">
        @endif
        <h1>{{ $title }}</h1>
        <div class="subtitle">{{ $subtitle }}</div>
        <div class="meta">Tenant: {{ $tenant }}</div>
        <div class="meta">Generated: {{ $generated }}</div>
        <div class="footer">Template slide - replace with report sections and visuals.</div>
    </div>
</body>
</html>
