<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111827; }
        .header { display: flex; align-items: center; gap: 16px; margin-bottom: 16px; }
        .logo { height: 48px; }
        h1 { font-size: 20px; margin: 0; }
        .subtitle { font-size: 12px; color: #4b5563; margin-top: 4px; }
        .meta { margin-top: 8px; font-size: 12px; color: #374151; }
        .meta-row { display: flex; gap: 8px; margin-top: 4px; }
        .meta-label { min-width: 120px; color: #6b7280; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; margin-top: 16px; }
        th, td { border: 1px solid #e5e7eb; padding: 8px; text-align: left; }
        th { background: #111827; color: #fff; }
        .watermark { position: fixed; top: 30%; left: 20%; width: 60%; opacity: 0.08; z-index: -1; }
    </style>
</head>
<body>
    @if ($logo)
        <img class="watermark" src="{{ $logo }}" alt="Watermark">
    @endif
    <div class="header">
        @if ($logo)
            <img class="logo" src="{{ $logo }}" alt="Logo">
        @endif
        <div>
            <h1>{{ $title }}</h1>
            <div class="subtitle">{{ $subtitle }}</div>
            <div class="subtitle">Tenant: {{ $tenant }}</div>
        </div>
    </div>

    <div class="meta">
        @foreach ($meta as $label => $value)
            <div class="meta-row">
                <span class="meta-label">{{ $label }}</span>
                <span>{{ $value }}</span>
            </div>
        @endforeach
    </div>

    @php($headerRow = is_array($headers[0] ?? null) ? $headers[0] : $headers)
    <table>
        <thead>
            <tr>
                @foreach ($headerRow as $header)
                    <th>{{ $header }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach ($rows as $row)
                <tr>
                    @foreach ($row as $cell)
                        <td>{{ $cell }}</td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
