<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111827; }
        .header { display: flex; align-items: center; gap: 16px; margin-bottom: 16px; }
        .logo { height: 48px; }
        h1 { font-size: 20px; margin: 0; }
        .subtitle { font-size: 12px; color: #4b5563; margin-top: 4px; }
        .meta { margin-top: 8px; font-size: 12px; color: #374151; }
        .meta-row { display: flex; gap: 8px; margin-top: 4px; }
        .meta-label { min-width: 120px; color: #6b7280; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; margin-top: 16px; }
        th, td { border: 1px solid #e5e7eb; padding: 8px; text-align: left; }
        th { background: #111827; color: #fff; }
        .watermark { position: fixed; top: 30%; left: 20%; width: 60%; opacity: 0.08; z-index: -1; }
        .watermark-text { position: fixed; top: 38%; left: 0; width: 100%; text-align: center; font-size: 68px; letter-spacing: 6px; color: rgba(17, 24, 39, 0.08); transform: rotate(-20deg); z-index: -2; }
        .section-title { margin-top: 18px; font-size: 13px; font-weight: bold; color: #111827; }
        .status-pill { display: inline-block; padding: 4px 10px; border-radius: 999px; background: #111827; color: #fff; font-size: 11px; text-transform: uppercase; letter-spacing: 0.08em; }
    </style>
</head>
<body>
    @if ($logo)
        <img class="watermark" src="{{ $logo }}" alt="Watermark">
    @endif
    @if (!empty($watermarkText))
        <div class="watermark-text" style="color: {{ $watermarkColor ?? 'rgba(17, 24, 39, 0.08)' }};">{{ $watermarkText }}</div>
    @endif
    <div class="header">
        @if ($logo)
            <img class="logo" src="{{ $logo }}" alt="Logo">
        @endif
        <div>
            <h1>{{ $title }}</h1>
            <div class="subtitle">Tenant: {{ $tenant }}</div>
            <div class="subtitle">Asset: {{ $order->asset?->asset_tag ?? '-' }} - {{ $order->asset?->name ?? '-' }}</div>
            <div class="subtitle"><span class="status-pill">{{ strtoupper($order->priority ?? 'medium') }}</span></div>
        </div>
    </div>

    <div class="meta">
        @foreach ($meta as $label => $value)
            <div class="meta-row">
                <span class="meta-label">{{ $label }}</span>
                <span>{{ $value }}</span>
            </div>
        @endforeach
        <div class="meta-row">
            <span class="meta-label">Reported By</span>
            <span>{{ $order->reportedBy?->name ?? '-' }}</span>
        </div>
        <div class="meta-row">
            <span class="meta-label">Assigned To</span>
            <span>{{ $order->assignedTo?->name ?? '-' }}</span>
        </div>
        <div class="meta-row">
            <span class="meta-label">Description</span>
            <span>{!! nl2br(e($descriptionText ?? ($order->description ?? '-'))) !!}</span>
        </div>
    </div>

    @if (!empty($actionPlan))
        <div class="section-title">Remedial Action Plan</div>
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($actionPlan as $index => $action)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $action }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    <div class="section-title">Parts & Resources</div>
    <table>
        <thead>
            <tr>
                <th>SKU</th>
                <th>Description</th>
                <th>Qty</th>
                <th>Unit Cost</th>
                <th>Total Cost</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($parts as $row)
                <tr>
                    @foreach ($row as $cell)
                        <td>{{ $cell }}</td>
                    @endforeach
                </tr>
            @empty
                <tr>
                    <td colspan="5">No parts recorded.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="section-title">Notes & Updates</div>
    <table>
        <thead>
            <tr>
                <th>Time</th>
                <th>Type</th>
                <th>By</th>
                <th>Note</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($notes as $note)
                <tr>
                    <td>{{ $note[0] }}</td>
                    <td>{{ $note[1] }}</td>
                    <td>{{ $note[2] }}</td>
                    <td>{{ $note[3] }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4">No notes yet.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>
