@extends('ui.layouts.app')
@php($active = 'poultry-alerts')

@section('title', 'Poultry Alerts')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">PoultryOps AI</p>
        <h1>Alerts</h1>
        <p class="sub">Filter and track active operational alerts.</p>
    </div>
</section>

<section class="card">
    <form class="filters" method="GET" action="{{ route('poultry.alerts.index') }}">
        <div class="filter-row">
            <select class="select" name="house_id">
                <option value="">All Houses</option>
                @foreach ($houses as $house)
                    <option value="{{ $house->id }}" @selected(request('house_id') == $house->id)>{{ $house->name }}</option>
                @endforeach
            </select>
            <select class="select" name="severity">
                <option value="">All Severities</option>
                @foreach (['info', 'warn', 'critical'] as $level)
                    <option value="{{ $level }}" @selected(request('severity') == $level)>{{ ucfirst($level) }}</option>
                @endforeach
            </select>
            <select class="select" name="status">
                <option value="">All Status</option>
                @foreach (['open', 'ack', 'closed'] as $state)
                    <option value="{{ $state }}" @selected(request('status') == $state)>{{ ucfirst($state) }}</option>
                @endforeach
            </select>
            <button class="btn btn-primary" type="submit">Filter</button>
        </div>
    </form>
</section>

<section class="grid-2">
    @forelse ($alerts as $alert)
        <article class="card alert-card">
            <div class="alert-title">{{ $alert->title }}</div>
            <div class="alert-sub">{{ $alert->message }}</div>
            <div class="alert-meta">
                <span>{{ $alert->house?->name }}</span>
                <span></span>
                <span>{{ ucfirst($alert->severity) }}</span>
                <span></span>
                <span>{{ ucfirst($alert->status) }}</span>
            </div>
        </article>
    @empty
        <article class="card">
            <div class="card-title">No alerts found</div>
        </article>
    @endforelse
</section>

<div class="card">
    {{ $alerts->links() }}
</div>
@endsection
