@extends('ui.layouts.app')
@php($active = 'poultry-dashboard')

@section('title', 'PoultryOps AI Dashboard')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">PoultryOps AI</p>
        <h1>Broiler Operations Dashboard</h1>
        <p class="sub">Live house health, weight trends, and alerts for a 5,000-capacity run.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/reports">View Reports</a>
        <a class="btn btn-primary" href="/alerts">Open Alerts</a>
    </div>
</section>

<section class="grid-3">
    @forelse ($cards as $card)
        @php($house = $card['house'])
        <article class="card">
            <div class="card-head">
                <div>
                    <div class="card-title"><a href="/houses/{{ $house->id }}">{{ $house->name }}</a></div>
                    <div class="card-sub">Age {{ $house->age_days }} days  Capacity {{ $house->capacity }}</div>
                </div>
                <span class="badge {{ ($card['open_alerts'] ?? 0) > 0 ? 'badge-warning' : '' }}">{{ $card['open_alerts'] ?? 0 }} alerts</span>
            </div>
            <div class="stat-grid">
                <div class="stat-card">
                    <div class="stat-label">Temp (C)</div>
                    <div class="stat-value">{{ $card['temp'] !== null ? number_format($card['temp'], 1) : '-' }}</div>
                </div>
                <div class="stat-card">
                    <div class="stat-label">Humidity (%)</div>
                    <div class="stat-value">{{ $card['humidity'] !== null ? number_format($card['humidity'], 1) : '-' }}</div>
                </div>
                <div class="stat-card">
                    <div class="stat-label">Water Flow (LPM)</div>
                    <div class="stat-value">{{ $card['water_flow'] !== null ? number_format($card['water_flow'], 1) : '-' }}</div>
                </div>
                <div class="stat-card">
                    <div class="stat-label">Feed Level (%)</div>
                    <div class="stat-value">{{ $card['feed_level'] !== null ? number_format($card['feed_level'], 0) : '-' }}</div>
                </div>
                <div class="stat-card">
                    <div class="stat-label">Avg Weight (g)</div>
                    <div class="stat-value">{{ $card['weight'] !== null ? number_format($card['weight'], 0) : '-' }}</div>
                </div>
                <div class="stat-card">
                    <div class="stat-label">Behavior Abnormal</div>
                    <div class="stat-value">{{ $card['behavior'] !== null ? number_format($card['behavior'], 2) : '-' }}</div>
                </div>
            </div>
        </article>
    @empty
        <article class="card">
            <div class="card-title">No houses found</div>
            <p class="sub">Seed demo data with <code>php artisan poultry:seed-demo</code>.</p>
        </article>
    @endforelse
</section>
@endsection
