@extends('ui.layouts.app')
@php($active = 'poultry-houses')

@section('title', 'House ' . $house->name)

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">House Detail</p>
        <h1>{{ $house->name }}</h1>
        <p class="sub">Age {{ $house->age_days }} days  Capacity {{ $house->capacity }}  Timezone {{ $house->timezone }}</p>
    </div>
    <div class="page-actions">
        <form method="POST" action="{{ route('poultry.houses.ai', $house) }}">
            @csrf
            <input type="hidden" name="period" value="daily" />
            <button class="btn btn-primary" type="submit">Generate AI Summary</button>
        </form>
    </div>
</section>

@if (session('status'))
    <div class="card">{{ session('status') }}</div>
@endif

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Temperature & Humidity (24h)</div>
                <div class="card-sub">Environmental stability</div>
            </div>
        </div>
        <canvas id="envChart" height="140"></canvas>
    </article>

    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Water & Feed Level (24h)</div>
                <div class="card-sub">Resource flow indicators</div>
            </div>
        </div>
        <canvas id="resourceChart" height="140"></canvas>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Weight Trend (7 days)</div>
                <div class="card-sub">Average weight samples</div>
            </div>
        </div>
        <canvas id="weightChart" height="140"></canvas>
    </article>

    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Behavior Abnormal Score (24h)</div>
                <div class="card-sub">Crowding and lethargy signals</div>
            </div>
        </div>
        <canvas id="behaviorChart" height="140"></canvas>
    </article>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Feed Logs</div>
        <div class="list">
            @forelse ($feedLogs as $log)
                <div class="list-item">
                    <div>
                        <div class="item-title">{{ $log->date->toDateString() }}</div>
                        <div class="item-sub">{{ $log->note ?? 'Routine feed intake' }}</div>
                    </div>
                    <span class="badge">{{ number_format($log->feed_kg, 1) }} kg</span>
                </div>
            @empty
                <div class="list-item"><div class="item-title">No feed logs</div></div>
            @endforelse
        </div>
    </article>

    <article class="card">
        <div class="card-title">Water Logs</div>
        <div class="list">
            @forelse ($waterLogs as $log)
                <div class="list-item">
                    <div>
                        <div class="item-title">{{ $log->date->toDateString() }}</div>
                        <div class="item-sub">{{ $log->note ?? 'Routine water intake' }}</div>
                    </div>
                    <span class="badge">{{ number_format($log->water_l, 1) }} L</span>
                </div>
            @empty
                <div class="list-item"><div class="item-title">No water logs</div></div>
            @endforelse
        </div>
    </article>

    <article class="card">
        <div class="card-title">Mortality Logs</div>
        <div class="list">
            @forelse ($mortalityLogs as $log)
                <div class="list-item">
                    <div>
                        <div class="item-title">{{ $log->date->toDateString() }}</div>
                        <div class="item-sub">{{ $log->note ?? 'Daily checks' }}</div>
                    </div>
                    <span class="badge">{{ $log->deaths }} deaths</span>
                </div>
            @empty
                <div class="list-item"><div class="item-title">No mortality logs</div></div>
            @endforelse
        </div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Open Alerts</div>
        <div class="stack">
            @forelse ($alerts as $alert)
                <div class="stack-item">
                    <div>
                        <div class="item-title">{{ $alert->title }}</div>
                        <div class="item-sub">{{ $alert->message }}</div>
                    </div>
                    <span class="badge {{ $alert->severity === 'critical' ? 'badge-danger' : 'badge-warning' }}">{{ ucfirst($alert->severity) }}</span>
                </div>
            @empty
                <div class="stack-item"><div class="item-title">No alerts</div></div>
            @endforelse
        </div>
    </article>

    <article class="card">
        <div class="card-title">Latest AI Report</div>
        @if ($latestReport)
            <div class="alert-card">
                <div class="alert-title">{{ ucfirst($latestReport->period ?? 'daily') }} report ({{ $latestReport->created_at->toDateString() }})</div>
                <div class="alert-sub" style="white-space: pre-wrap;">{{ $latestReport->report_text ?? $latestReport->content }}</div>
                <div class="alert-meta">Report ID {{ $latestReport->id }}</div>
            </div>
        @else
            <p class="sub">No AI reports yet. Generate a summary to start.</p>
        @endif
    </article>
</section>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const envLabels = @json($environment['labels']);
    const tempValues = @json($environment['datasets']['temp_c']);
    const humidityValues = @json($environment['datasets']['humidity_pct']);

    new Chart(document.getElementById('envChart'), {
        type: 'line',
        data: {
            labels: envLabels,
            datasets: [
                { label: 'Temp (C)', data: tempValues, borderColor: '#22d3ee', tension: 0.3 },
                { label: 'Humidity (%)', data: humidityValues, borderColor: '#f59e0b', tension: 0.3 },
            ]
        },
        options: { scales: { x: { display: false } }, plugins: { legend: { labels: { color: '#e9eef6' } } } }
    });

    const resourceLabels = @json($waterFeed['labels']);
    const waterValues = @json($waterFeed['datasets']['water_flow_lpm']);
    const feedValues = @json($waterFeed['datasets']['feed_level_pct']);

    new Chart(document.getElementById('resourceChart'), {
        type: 'line',
        data: {
            labels: resourceLabels,
            datasets: [
                { label: 'Water Flow (LPM)', data: waterValues, borderColor: '#10b981', tension: 0.3 },
                { label: 'Feed Level (%)', data: feedValues, borderColor: '#f97316', tension: 0.3 },
            ]
        },
        options: { scales: { x: { display: false } }, plugins: { legend: { labels: { color: '#e9eef6' } } } }
    });

    new Chart(document.getElementById('weightChart'), {
        type: 'line',
        data: {
            labels: @json($weightLabels),
            datasets: [
                { label: 'Avg Weight (g)', data: @json($weightValues), borderColor: '#38bdf8', tension: 0.3 },
            ]
        },
        options: { scales: { x: { display: false } }, plugins: { legend: { labels: { color: '#e9eef6' } } } }
    });

    new Chart(document.getElementById('behaviorChart'), {
        type: 'line',
        data: {
            labels: @json($behaviorLabels),
            datasets: [
                { label: 'Abnormal Score', data: @json($behaviorValues), borderColor: '#f43f5e', tension: 0.3 },
            ]
        },
        options: { scales: { x: { display: false }, y: { min: 0, max: 1 } }, plugins: { legend: { labels: { color: '#e9eef6' } } } }
    });
</script>
@endsection
