@extends('ui.layouts.app')
@php($active = 'poultry-reports')

@section('title', 'Report #' . $report->id)

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">PoultryOps AI</p>
        <h1>{{ ucfirst($report->period ?? 'daily') }} Report</h1>
        <p class="sub">House: {{ $report->house?->name ?? 'Unknown' }}  {{ $report->created_at->toDateTimeString() }}</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="{{ route('poultry.reports.index') }}">Back to Reports</a>
    </div>
</section>

<article class="card" style="white-space: pre-wrap;">
    {{ $report->report_text ?? $report->content }}
</article>

@if ($report->metrics_json)
    <article class="card">
        <div class="card-title">Metrics Snapshot</div>
        <pre style="white-space: pre-wrap; font-size: 12px;">{{ json_encode($report->metrics_json, JSON_PRETTY_PRINT) }}</pre>
    </article>
@endif
@endsection
