@extends('ui.layouts.app')
@php($active = 'poultry-reports')

@section('title', 'Poultry Reports')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">PoultryOps AI</p>
        <h1>AI Reports</h1>
        <p class="sub">Daily and weekly summaries with KPI snapshots.</p>
    </div>
</section>

<section class="card">
    <form class="filters" method="GET" action="{{ route('poultry.reports.index') }}">
        <div class="filter-row">
            <select class="select" name="house_id">
                <option value="">All Houses</option>
                @foreach ($houses as $house)
                    <option value="{{ $house->id }}" @selected(request('house_id') == $house->id)>{{ $house->name }}</option>
                @endforeach
            </select>
            <select class="select" name="period">
                <option value="">All Periods</option>
                @foreach (['daily', 'weekly'] as $period)
                    <option value="{{ $period }}" @selected(request('period') == $period)>{{ ucfirst($period) }}</option>
                @endforeach
            </select>
            <button class="btn btn-primary" type="submit">Filter</button>
        </div>
    </form>
</section>

<section class="grid-2">
    @forelse ($reports as $report)
        <article class="card">
            <div class="card-title">
                <a href="{{ route('poultry.reports.show', $report) }}">{{ ucfirst($report->period ?? 'daily') }} report</a>
            </div>
            <div class="card-sub">House: {{ $report->house?->name ?? 'Unknown' }}</div>
            <div class="alert-meta">{{ $report->created_at->toDateTimeString() }}</div>
            <div class="alert-sub" style="white-space: pre-wrap; margin-top: 12px;">{{ \Illuminate\Support\Str::limit($report->report_text ?? $report->content, 220) }}</div>
        </article>
    @empty
        <article class="card">
            <div class="card-title">No reports yet</div>
        </article>
    @endforelse
</section>

<div class="card">
    {{ $reports->links() }}
</div>
@endsection
