<div class="section-card">
    <h3>{{ $section['title'] }}
        <span class="pill {{ $section['severity'] ?? 'info' }}">{{ strtoupper($section['severity'] ?? 'info') }}</span>
    </h3>
    <div class="muted">{{ $section['purpose'] }}</div>

    @if ($section['no_data'])
        <div class="muted">No run data for this agent in the selected window.</div>
    @else
        @if (!empty($section['metrics']))
            <div class="section">
                <strong>Key Metrics</strong>
                <table>
                    <thead>
                        <tr>
                            <th>Metric</th>
                            <th>Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($section['metrics'] as $metric => $value)
                            <tr>
                                <td>{{ \Illuminate\Support\Str::headline(str_replace('_', ' ', $metric)) }}</td>
                                <td>{{ is_numeric($value) ? $value : (string) $value }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif

        @if (!empty($section['findings']))
            <div class="section">
                <strong>Top Findings</strong>
                <ul>
                    @foreach ($section['findings'] as $finding)
                        <li>{{ is_array($finding) ? ($finding['title'] ?? json_encode($finding)) : $finding }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if (!empty($section['recommended_actions']))
            <div class="section">
                <strong>Recommended Actions</strong>
                <ul>
                    @foreach ($section['recommended_actions'] as $action)
                        <li>{{ $action }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    @endif

    @if (!empty($section['data_confidence']))
        <div class="section">
            <strong>Data Confidence</strong>
            <ul>
                @foreach ($section['data_confidence'] as $note)
                    <li>{{ $note }}</li>
                @endforeach
            </ul>
        </div>
    @endif
</div>
