<div class="section-card">
    <h2>Executive Summary</h2>
    <div class="section">
        <h3>Headline KPIs</h3>
        <table>
            <thead>
                <tr>
                    <th>Availability</th>
                    <th>Utilization</th>
                    <th>MTBF</th>
                    <th>Fuel Efficiency</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $executive['headline_kpis']['availability'] !== null ? number_format($executive['headline_kpis']['availability'], 1) . '%' : 'N/A' }}</td>
                    <td>{{ $executive['headline_kpis']['utilization'] !== null ? number_format($executive['headline_kpis']['utilization'], 1) . '%' : 'N/A' }}</td>
                    <td>{{ $executive['headline_kpis']['mtbf'] !== null ? $executive['headline_kpis']['mtbf'] . 'h' : 'N/A' }}</td>
                    <td>{{ $executive['headline_kpis']['fuel_efficiency'] !== null ? number_format($executive['headline_kpis']['fuel_efficiency'], 2) . ' L/hr' : 'N/A' }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <h3>Top Risks</h3>
        @if (!empty($executive['top_risks']))
            <ul>
                @foreach ($executive['top_risks'] as $risk)
                    <li>{{ $risk }}</li>
                @endforeach
            </ul>
        @else
            <div class="muted">No major risks recorded.</div>
        @endif
    </div>

    <div class="section">
        <h3>Top Wins</h3>
        @if (!empty($executive['top_wins']))
            <ul>
                @foreach ($executive['top_wins'] as $win)
                    <li>{{ $win }}</li>
                @endforeach
            </ul>
        @else
            <div class="muted">No wins recorded.</div>
        @endif
    </div>

    <div class="section">
        <h3>Finance Highlights</h3>
        <table>
            <thead>
                <tr>
                    <th>Total Spend (MTD)</th>
                    <th>Spend vs Budget</th>
                    <th>Unpaid Total</th>
                    <th>PR Aging</th>
                    <th>PO Aging</th>
                    <th>Invoice Aging</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $executive['total_spend'] !== null ? '$' . number_format($executive['total_spend'], 2) : 'N/A' }}</td>
                    <td>{{ $executive['spend_vs_budget'] !== null ? number_format($executive['spend_vs_budget'], 1) . '%' : 'N/A' }}</td>
                    <td>{{ $executive['unpaid_total'] !== null ? '$' . number_format($executive['unpaid_total'], 2) : 'N/A' }}</td>
                    <td>{{ $executive['pr_aging_days'] !== null ? number_format($executive['pr_aging_days'], 1) . ' days' : 'N/A' }}</td>
                    <td>{{ $executive['po_aging_days'] !== null ? number_format($executive['po_aging_days'], 1) . ' days' : 'N/A' }}</td>
                    <td>{{ $executive['invoice_aging_days'] !== null ? number_format($executive['invoice_aging_days'], 1) . ' days' : 'N/A' }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    @if (!empty($executive['data_confidence']))
        <div class="section">
            <h3>Data Confidence Notes</h3>
            <ul>
                @foreach ($executive['data_confidence'] as $note)
                    <li>{{ $note }}</li>
                @endforeach
            </ul>
        </div>
    @endif
</div>
