<div class="section-card">
    <div class="section">
        <strong>Finance Metrics</strong>
        <table>
            <thead>
                <tr>
                    <th>PR Aging (days)</th>
                    <th>PO Aging (days)</th>
                    <th>Invoice Aging (days)</th>
                    <th>Unpaid Total</th>
                    <th>Spend vs Budget</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $finance['metrics']['pr_aging_days'] ?? 'N/A' }}</td>
                    <td>{{ $finance['metrics']['po_aging_days'] ?? 'N/A' }}</td>
                    <td>{{ $finance['metrics']['invoice_aging_days'] ?? 'N/A' }}</td>
                    <td>{{ isset($finance['metrics']['unpaid_total']) ? '$' . number_format($finance['metrics']['unpaid_total'], 2) : 'N/A' }}</td>
                    <td>{{ isset($finance['metrics']['spend_vs_budget']) ? number_format($finance['metrics']['spend_vs_budget'], 1) . '%' : 'N/A' }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <strong>Invoice Aging Buckets</strong>
        <table>
            <thead>
                <tr>
                    <th>0-30</th>
                    <th>31-60</th>
                    <th>61-90</th>
                    <th>90+</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ isset($finance['aging_buckets']['0-30']) ? '$' . number_format($finance['aging_buckets']['0-30'], 2) : 'N/A' }}</td>
                    <td>{{ isset($finance['aging_buckets']['31-60']) ? '$' . number_format($finance['aging_buckets']['31-60'], 2) : 'N/A' }}</td>
                    <td>{{ isset($finance['aging_buckets']['61-90']) ? '$' . number_format($finance['aging_buckets']['61-90'], 2) : 'N/A' }}</td>
                    <td>{{ isset($finance['aging_buckets']['90+']) ? '$' . number_format($finance['aging_buckets']['90+'], 2) : 'N/A' }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <strong>Top Unpaid Exposure by Vendor</strong>
        @if (!empty($finance['top_vendors']))
            <table>
                <thead>
                    <tr>
                        <th>Vendor</th>
                        <th>Unpaid Exposure</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($finance['top_vendors'] as $vendor => $amount)
                        <tr>
                            <td>{{ $vendor }}</td>
                            <td>${{ number_format($amount, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="muted">No unpaid exposure data available.</div>
        @endif
    </div>

    <div class="section">
        <strong>Flagged Items</strong>
        @if (!empty($finance['findings']))
            <ul>
                @foreach ($finance['findings'] as $finding)
                    <li>{{ $finding['title'] ?? $finding }}</li>
                @endforeach
            </ul>
        @else
            <div class="muted">No finance findings captured.</div>
        @endif
    </div>

    @if (!empty($finance['data_confidence']))
        <div class="section">
            <strong>Data Confidence</strong>
            <ul>
                @foreach ($finance['data_confidence'] as $note)
                    <li>{{ $note }}</li>
                @endforeach
            </ul>
        </div>
    @endif
</div>
