<div class="section-card">
    <div class="section">
        <strong>Artisan Utilization & Compliance</strong>
        @if (!empty($hr['metrics']))
            <table>
                <thead>
                    <tr>
                        <th>Artisan</th>
                        <th>Assigned</th>
                        <th>Completed</th>
                        <th>Avg Close (hrs)</th>
                        <th>Utilization</th>
                        <th>Compliance</th>
                        <th>Repeat Failures</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($hr['metrics'] as $row)
                        <tr>
                            <td>{{ $row['artisan_name'] ?? '-' }}</td>
                            <td>{{ $row['assigned'] ?? 0 }}</td>
                            <td>{{ $row['completed'] ?? 0 }}</td>
                            <td>{{ $row['avg_close_hours'] ?? 'N/A' }}</td>
                            <td>{{ isset($row['utilization']) ? number_format($row['utilization'] * 100, 1) . '%' : 'N/A' }}</td>
                            <td>{{ isset($row['compliance_rate']) ? number_format($row['compliance_rate'] * 100, 1) . '%' : 'N/A' }}</td>
                            <td>{{ $row['repeat_failures'] ?? 0 }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="muted">No artisan metrics captured.</div>
        @endif
    </div>

    <div class="section">
        <strong>Findings</strong>
        @if (!empty($hr['findings']))
            <ul>
                @foreach ($hr['findings'] as $finding)
                    <li>{{ $finding['title'] ?? $finding }}</li>
                @endforeach
            </ul>
        @else
            <div class="muted">No HR findings captured.</div>
        @endif
    </div>

    @if (!empty($hr['data_confidence']))
        <div class="section">
            <strong>Data Confidence</strong>
            <ul>
                @foreach ($hr['data_confidence'] as $note)
                    <li>{{ $note }}</li>
                @endforeach
            </ul>
        </div>
    @endif
</div>
