<div class="section-card">
    <div class="section">
        <strong>Overdue PM (Top 15)</strong>
        @if (!empty($maintenance['overdue']))
            <ul>
                @foreach ($maintenance['overdue'] as $item)
                    <li>{{ $item }}</li>
                @endforeach
            </ul>
        @else
            <div class="muted">No overdue PM items captured.</div>
        @endif
    </div>

    <div class="section">
        <strong>Plant Downtime Summary</strong>
        <table>
            <thead>
                <tr>
                    <th>Total Downtime (hrs)</th>
                    <th>Top Causes</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ number_format($maintenance['downtime_hours'] ?? 0, 1) }}</td>
                    <td>
                        @if (!empty($maintenance['downtime_reasons']))
                            {{ implode(', ', $maintenance['downtime_reasons']) }}
                        @else
                            <span class="muted">No downtime reasons logged.</span>
                        @endif
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <strong>Failure Prediction (Top 10)</strong>
        @if (!empty($maintenance['failure_risks']))
            <ul>
                @foreach ($maintenance['failure_risks'] as $risk)
                    <li>{{ $risk }}</li>
                @endforeach
            </ul>
        @else
            <div class="muted">No failure risks captured.</div>
        @endif
    </div>

    @if (!empty($maintenance['data_confidence']))
        <div class="section">
            <strong>Data Confidence</strong>
            <ul>
                @foreach ($maintenance['data_confidence'] as $note)
                    <li>{{ $note }}</li>
                @endforeach
            </ul>
        </div>
    @endif
</div>
