<div class="section-card">
    <div class="section">
        <strong>Notification Summary by Channel</strong>
        @if (!empty($notifications['by_channel']))
            <table>
                <thead>
                    <tr>
                        <th>Channel</th>
                        <th>Queued</th>
                        <th>Sent</th>
                        <th>Failed</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($notifications['by_channel'] as $row)
                        <tr>
                            <td>{{ strtoupper((string) $row['channel']) }}</td>
                            <td>{{ $row['queued'] }}</td>
                            <td>{{ $row['sent'] }}</td>
                            <td>{{ $row['failed'] }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="muted">No notification activity captured.</div>
        @endif
    </div>

    <div class="section">
        <strong>Notification Summary by Severity</strong>
        @if (!empty($notifications['by_severity']))
            <table>
                <thead>
                    <tr>
                        <th>Severity</th>
                        <th>Count</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($notifications['by_severity'] as $row)
                        <tr>
                            <td>{{ strtoupper($row['severity']) }}</td>
                            <td>{{ $row['count'] }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="muted">No severity summary available.</div>
        @endif
    </div>

    <div class="section">
        <strong>ALARM Escalations</strong>
        @if (!empty($notifications['alarm_escalations']))
            <ul>
                @foreach ($notifications['alarm_escalations'] as $row)
                    <li>{{ $row['title'] }} ({{ strtoupper($row['channel']) }} - {{ $row['status'] }}): {{ $row['message'] }}</li>
                @endforeach
            </ul>
        @else
            <div class="muted">No alarm escalations recorded.</div>
        @endif
    </div>
</div>
