@extends('ui.layouts.app')
@php
    $active = 'agent-notifications';
@endphp

@section('title', 'Agent Notification Detail')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Intelligence</p>
        <h1>{{ $notification->title }}</h1>
        <p class="sub">{{ $notification->agent_name }}</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Export</button>
        <a class="btn btn-primary" href="/ui/agent-notifications">Back to Log</a>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Summary</div>
        <p class="card-sub">Sent {{ $notification->sent_at?->format('M d, H:i') ?? '-' }}</p>
        <div class="list">
            <div class="list-item"><span>Severity</span><span class="badge">{{ strtoupper($notification->severity ?? 'info') }}</span></div>
            <div class="list-item"><span>Status</span><span>{{ ucfirst($notification->status) }}</span></div>
            <div class="list-item"><span>Recipients</span><span>{{ $notification->recipients ? implode(', ', $notification->recipients) : '-' }}</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Message</div>
        <div class="card-sub">Telegram payload</div>
        <pre class="code-block">{{ $notification->summary }}</pre>
    </div>
</section>

<section class="card">
    <div class="card-title">Payload</div>
    <div class="card-sub">Structured context captured by the agent</div>
    <pre class="code-block">{{ json_encode($notification->payload, JSON_PRETTY_PRINT) }}</pre>
</section>
@endsection
