@extends('ui.layouts.app')
@php
    $active = 'agent-notifications';
@endphp

@section('title', 'AI Agent Notifications')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Intelligence</p>
        <h1>AI Agent Notifications</h1>
        <p class="sub">Automated compliance, prediction, KPI, and cost control alerts.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Export Log</button>
        <button class="btn btn-primary">Run Agents</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Agent Runs</div>
            <div class="card-sub">Latest notifications delivered to Telegram</div>
        </div>
        <div class="chip">Last 50</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Agent</div><div>Title</div><div>Severity</div><div>Status</div><div>Sent</div><div>Recipients</div>
        </div>
        @forelse($notifications as $notification)
            @php
                $severity = strtolower($notification->severity ?? 'info');
                $badgeClass = $severity === 'alarm' ? 'badge-warning' : ($severity === 'warn' ? 'badge-live' : 'badge');
                $recipients = $notification->recipients ? implode(', ', $notification->recipients) : '-';
            @endphp
            <a class="table-row" href="/ui/agent-notifications/{{ $notification->id }}">
                <div>{{ $notification->agent_name }}</div>
                <div>{{ $notification->title }}</div>
                <div><span class="badge {{ $badgeClass }}">{{ strtoupper($severity) }}</span></div>
                <div>{{ ucfirst($notification->status) }}</div>
                <div>{{ $notification->sent_at?->format('M d H:i') ?? '-' }}</div>
                <div>{{ $recipients }}</div>
            </a>
        @empty
            <div class="table-row">
                <div>No agent notifications yet.</div>
                <div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection
