@extends('ui.layouts.app')
@php($active = 'ai')

@section('title', 'AI Insight Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">AI Insight</p>
        <h1>Insight {{ $insightId ?? 'AI-332' }}</h1>
        <p class="sub">Recommendations derived from telemetry and history.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/ai">Back to AI</a>
        <button class="btn btn-primary">Create Work Order</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Insight</div>
        <p class="sub">Hydraulic temperature drift suggests pump wear within 120 hours.</p>
        <div class="list">
            <div class="list-item"><span>Asset</span><span class="chip">Excavator 12</span></div>
            <div class="list-item"><span>Confidence</span><span class="chip">0.86</span></div>
            <div class="list-item"><span>Impact</span><span class="chip">Medium</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Recommended Actions</div>
        <div class="list">
            <div class="list-item"><span>Inspect pump seals</span><span class="badge badge-warning">7 days</span></div>
            <div class="list-item"><span>Adjust PM interval</span><span class="badge">Next cycle</span></div>
        </div>
    </div>
</section>
@endsection


