@extends('ui.layouts.app')
@php($active = 'assets')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($asset = $tenant ? \App\Models\Asset::with(['site', 'spares.part', 'workOrders', 'pmSchedules', 'maintenanceRecords', 'documents', 'assignments'])->where('tenant_id', $tenant->id)->where(function ($query) use ($assetId) { $query->where('id', $assetId)->orWhere('asset_tag', $assetId)->orWhere('name', $assetId); })->first() : null)
@php($workOrders = $asset ? $asset->workOrders()->latest()->take(3)->get() : collect())
@php($pmSchedule = $asset ? $asset->pmSchedules()->orderBy('next_meter_reading')->first() : null)
@php($aiInsights = $asset ? \App\Models\AiInsight::where('tenant_id', $tenant->id)->where('asset_id', $asset->id)->latest()->take(3)->get() : collect())
@php($assignments = $asset ? $asset->assignments()->latest()->take(3)->get() : collect())
@php($documents = $asset ? $asset->documents()->latest()->take(3)->get() : collect())

@section('title', 'Asset Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Asset Detail</p>
        <h1>{{ $asset?->name ?? 'Asset' }} - {{ $asset?->asset_tag ?? $assetId ?? 'Unknown' }}</h1>
        <p class="sub">Lifecycle, utilization, documents, and assignments.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/assets">Back to Assets</a>
        <button class="btn btn-primary">Edit Asset</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Asset Profile</div>
        <div class="list">
            <div class="list-item"><span>Category</span><span class="chip">{{ $asset?->category ?? '-' }}</span></div>
            <div class="list-item"><span>Make / Model</span><span class="chip">{{ trim(($asset?->make ?? '') . ' ' . ($asset?->model ?? '')) ?: '-' }}</span></div>
            <div class="list-item"><span>Serial</span><span class="chip">{{ $asset?->serial_number ?? '-' }}</span></div>
            <div class="list-item"><span>Site</span><span class="chip">{{ $asset?->site?->name ?? $asset?->location ?? 'Unassigned' }}</span></div>
            <div class="list-item">
                <span>Status</span>
                <span class="badge {{ ($asset?->lifecycle_status ?? 'active') === 'down' ? 'badge-warning' : 'badge-live' }}">
                    {{ ucfirst($asset?->lifecycle_status ?? 'active') }}
                </span>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Utilization</div>
        <div class="metric">{{ $asset?->meter_reading ? number_format($asset->meter_reading, 0) : '-' }} {{ $asset?->meter_type ?? 'hrs' }}</div>
        <div class="metric-sub">Service frequency: {{ $asset?->service_frequency ?? ($asset?->maintenance_interval ? $asset->maintenance_interval . ' ' . ($asset->meter_type ?? 'hrs') : '-') }}</div>
        <div class="list">
            <div class="list-item"><span>Health Score</span><span class="chip">{{ $asset ? 80 + ($asset->id % 20) : '-' }}%</span></div>
            <div class="list-item"><span>Next PM</span><span class="chip">{{ $pmSchedule?->name ?? '-' }}</span></div>
            <div class="list-item"><span>Warranty</span><span class="chip">{{ $asset?->warranty_expiry?->format('M Y') ?? '-' }}</span></div>
        </div>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Availability Trend</div>
                <div class="card-sub">Last 12 weeks</div>
            </div>
            <span class="chip">95.4% avg</span>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 92 L40 74 L80 86 L120 62 L160 48 L200 60 L240 40 L260 34 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,92 40,74 80,86 120,62 160,48 200,60 240,40 260,34"></polyline>
                <circle class="trend-dot" cx="40" cy="74" r="3"></circle>
                <circle class="trend-dot" cx="120" cy="62" r="3"></circle>
                <circle class="trend-dot" cx="200" cy="60" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="34" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Availability 84-97%</span>
            <span>Unplanned downtime 6.2h</span>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Reliability & Incidents</div>
        <div class="stat-grid">
            <div class="stat-card">
                <div class="stat-label">MTBF</div>
                <div class="stat-value">242 hrs</div>
                <div class="stat-sub">+8% vs last quarter</div>
            </div>
            <div class="stat-card">
                <div class="stat-label">MTTR</div>
                <div class="stat-value">3.4 hrs</div>
                <div class="stat-sub">-12% vs last quarter</div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Reliability</div>
                <div class="stat-value">96.1%</div>
                <div class="stat-sub">Target 95%</div>
            </div>
        </div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Hydraulic leak</div>
                    <div class="item-sub">2 incidents in 30 days</div>
                </div>
                <span class="badge badge-warning">Watch</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Track wear</div>
                    <div class="item-sub">1 incident in 30 days</div>
                </div>
                <span class="badge">Monitor</span>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Maintenance History</div>
            <div class="card-sub">Last 90 days</div>
        </div>
        <button class="btn btn-ghost">View all</button>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Date</div><div>Work Order</div><div>Type</div><div>Downtime</div><div>Cost</div><div>Status</div>
        </div>
        @forelse ($workOrders as $order)
            <div class="table-row">
                <div>{{ ($order->completed_at ?? $order->created_at)?->format('M d') ?? '-' }}</div>
                <div>{{ $order->reference_code ?? ('WO-' . $order->id) }}</div>
                <div>{{ ucfirst($order->type ?? 'service') }}</div>
                <div>-</div>
                <div>{{ $order->total_cost ? '$' . number_format($order->total_cost, 0) : '-' }}</div>
                <div><span class="badge {{ $order->status === 'open' ? 'badge-warning' : 'badge-live' }}">{{ ucfirst($order->status) }}</span></div>
            </div>
        @empty
            <div class="table-row">
                <div>No maintenance history yet.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Maintenance Costs</div>
        @php($totalCost = $asset ? $asset->workOrders()->sum('total_cost') : 0)
        @php($recentCost = $asset ? $asset->workOrders()->where('created_at', '>=', now()->subDays(30))->sum('total_cost') : 0)
        <div class="metric">{{ $totalCost ? '$' . number_format($totalCost, 0) : '-' }}</div>
        <div class="metric-sub">YTD | Last 30 days: {{ $recentCost ? '$' . number_format($recentCost, 0) : '-' }}</div>
        <div class="cost-row"><span>Labor</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Parts</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Contractor</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Fuel / Fluids</span><span class="chip">-</span></div>
    </article>
    <article class="card">
        <div class="card-title">AI Predictions</div>
        <div class="list">
            @forelse ($aiInsights as $insight)
                <div class="list-item">
                    <div>
                        <div class="item-title">{{ ucfirst(str_replace('_', ' ', $insight->type)) }}</div>
                        <div class="item-sub">{{ $insight->payload['summary'] ?? 'AI insight available' }}</div>
                    </div>
                    <span class="badge badge-ai">{{ $insight->confidence ? number_format($insight->confidence, 0) . '%' : 'AI' }}</span>
                </div>
            @empty
                <div class="list-item">
                    <div>
                        <div class="item-title">No predictions yet</div>
                        <div class="item-sub">Upload service history to generate insights.</div>
                    </div>
                    <span class="badge">-</span>
                </div>
            @endforelse
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Assignments</div>
            <div class="card-sub">Operator and artisan coverage</div>
        </div>
        <button class="btn btn-ghost">Manage</button>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Person</div><div>Role</div><div>Shift</div><div>Starts</div><div>Ends</div><div>Status</div>
        </div>
        @forelse ($assignments as $assignment)
            <div class="table-row">
                <div>{{ $assignment->user?->name ?? 'Assigned User' }}</div>
                <div>{{ $assignment->role ?? 'Operator' }}</div>
                <div>{{ $assignment->shift_name ?? 'Day' }}</div>
                <div>{{ $assignment->starts_at?->format('H:i') ?? '-' }}</div>
                <div>{{ $assignment->ends_at?->format('H:i') ?? '-' }}</div>
                <div><span class="badge badge-live">Scheduled</span></div>
            </div>
        @empty
            <div class="table-row">
                <div>No assignments yet.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Documents</div>
            <div class="card-sub">Insurance, permits, manuals</div>
        </div>
        <button class="btn btn-ghost">Upload</button>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Document</div><div>Type</div><div>Expiry</div><div>Status</div><div>Owner</div><div>Action</div>
        </div>
        @forelse ($documents as $document)
            <div class="table-row">
                <div>{{ basename($document->file_path) }}</div>
                <div>{{ ucfirst($document->type) }}</div>
                <div>{{ $document->expiry_date?->format('M d, Y') ?? '-' }}</div>
                <div><span class="badge badge-live">Active</span></div>
                <div>{{ $document->metadata['owner'] ?? 'Ops' }}</div>
                <div>View</div>
            </div>
        @empty
            <div class="table-row">
                <div>No documents uploaded.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection



