@extends('ui.layouts.app')
@php($active = 'assets')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($assets = $tenant ? \App\Models\Asset::with('site')->where('tenant_id', $tenant->id)->orderBy('name')->get() : collect())
@php($assets = $assets->unique(fn ($asset) => $asset->asset_tag ?: $asset->id)->values())
@php($categoryFilter = request('category'))
@php($categories = $assets->map(fn ($asset) => $asset->category ?: 'Uncategorized')->unique()->sort()->values())
@php($filteredAssets = $categoryFilter && strtolower($categoryFilter) !== 'all' ? $assets->filter(fn ($asset) => ($asset->category ?: 'Uncategorized') === $categoryFilter)->values() : $assets)
@php($assetCount = $filteredAssets->count())
@php($lifecycleCounts = $filteredAssets->groupBy(fn ($asset) => strtolower($asset->lifecycle_status ?: 'active'))->map->count())
@php($assetsByCategory = $filteredAssets->groupBy(fn ($asset) => $asset->category ?: 'Uncategorized'))

@section('title', 'Assets')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Assets</p>
        <h1>Asset Portfolio</h1>
        <p class="sub">Track lifecycle, warranties, and utilization by site.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Import</button>
        <button class="btn btn-primary">Add Asset</button>
    </div>
</section>

<section class="card filters">
    <form class="filter-row" method="get">
        <input class="input" name="q" value="{{ request('q') }}" placeholder="Search assets" />
        <select class="select" name="site">
            <option value="">All Sites</option>
            <option>North Ridge</option>
            <option>East Yard</option>
        </select>
        <select class="select" name="status">
            <option value="">Status: Any</option>
            <option>Active</option>
            <option>Inactive</option>
        </select>
        <select class="select" name="category">
            <option value="all" @selected(!$categoryFilter || strtolower($categoryFilter) === 'all')>All Categories</option>
            @foreach ($categories as $category)
                <option value="{{ $category }}" @selected($categoryFilter === $category)>{{ $category }}</option>
            @endforeach
        </select>
        <button class="btn btn-ghost" type="submit">Apply</button>
        <a class="btn btn-ghost" href="/ui/assets">Reset</a>
    </form>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Asset Health Trend</div>
                <div class="card-sub">Average health score</div>
            </div>
            <div class="chip">Last 12 weeks</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 86 L40 78 L80 74 L120 68 L160 62 L200 58 L240 52 L260 46 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,86 40,78 80,74 120,68 160,62 200,58 240,52 260,46"></polyline>
                <circle class="trend-dot" cx="80" cy="74" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="62" r="3"></circle>
                <circle class="trend-dot" cx="240" cy="52" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Avg health 88-94%</span>
            <span>High risk assets 6</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Lifecycle Mix</div>
            <div class="card-sub">Active, standby, down</div>
        </div>
        <div class="chip">{{ $assetCount }} assets</div>
    </div>
    <div class="chart-placeholder chart-placeholder--bars">
        <div class="chart-bars">
            <div class="chart-bar" style="--value: {{ $assetCount ? round(($lifecycleCounts['active'] ?? 0) / $assetCount * 100) : 0 }}%"><span>Active</span></div>
            <div class="chart-bar" style="--value: {{ $assetCount ? round(($lifecycleCounts['standby'] ?? 0) / $assetCount * 100) : 0 }}%"><span>Standby</span></div>
            <div class="chart-bar" style="--value: {{ $assetCount ? round(($lifecycleCounts['down'] ?? 0) / $assetCount * 100) : 0 }}%"><span>Down</span></div>
            <div class="chart-bar" style="--value: {{ $assetCount ? round(($lifecycleCounts['retired'] ?? 0) / $assetCount * 100) : 0 }}%"><span>Retired</span></div>
        </div>
    </div>
</article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Assets</div>
            <div class="card-sub">{{ $assetCount }} tracked assets</div>
        </div>
        <div class="chip">Updated {{ now()->diffForHumans() }}</div>
    </div>

    <div class="table">
        <div class="table-row table-head">
            <div>Asset</div><div>Name</div><div>Category</div><div>Location</div><div>Status</div><div>Health</div><div>Value</div>
        </div>
        @forelse ($assetsByCategory as $category => $group)
            <div class="table-row">
                <div><strong>{{ $category }}</strong></div>
                <div>{{ $group->count() }} assets</div>
                <div></div><div></div><div></div><div></div><div></div>
            </div>
            @foreach ($group as $asset)
                @php($health = $asset->lifecycle_status === 'down' ? 68 : 80 + ($asset->id % 20))
                @php($value = $asset->current_value ?? $asset->yearly_budget)
                <a class="table-row" href="/ui/assets/{{ $asset->id }}">
                    <div class="media-cell">
                        <img class="thumb" src="/ui-assets/images/asset-excavator.svg" alt="{{ $asset->name }}">
                        <div>{{ $asset->asset_tag ?: 'ASSET' }}</div>
                    </div>
                    <div>{{ $asset->name }}</div>
                    <div>{{ $asset->category ?: 'Uncategorized' }}</div>
                    <div>{{ $asset->site?->name ?? $asset->location ?? 'Unassigned' }}</div>
                    <div>
                        <span class="badge {{ $asset->lifecycle_status === 'down' ? 'badge-warning' : 'badge-live' }}">
                            {{ ucfirst($asset->lifecycle_status ?: 'active') }}
                        </span>
                    </div>
                    <div>{{ $health }}%</div>
                    <div>{{ $value !== null ? '$' . number_format($value, 0) : '-' }}</div>
                </a>
            @endforeach
        @empty
            <div class="table-row">
                <div>No assets found.</div><div></div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection



